import { ExtendedManagementSettings } from '@signageos/common-types/dist/Device/Settings/DeviceSettings';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import Responsibility from '../../Feature/Responsibility';
import ManagementCapability from '../../NativeDevice/Management/ManagementCapability';
import IGetTelemetryProperties from '../Device/Telemetry/IGetTelemetryProperties';
import { createDeviceTelemetrySaga } from '../Device/Telemetry/deviceTelemetrySagas';

export const telemetryExtendedManagementSettingsSaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.EXTENDED_MANAGEMENT,
	Responsibility.EXTENDED_MANAGEMENT,
	[ManagementCapability.EXTENDED_MANAGEMENT],
	getExtendedManagementTelemetry,
);

export async function getExtendedManagementTelemetry({ managementDriver }: IGetTelemetryProperties): Promise<ExtendedManagementSettings> {
	const url = await managementDriver.getExtendedManagementUrl();
	return { url };
}
