import { DeviceSettingsType } from '@signageos/common-types/dist/Device/Settings/DeviceSettingsType';
import Responsibility from '../../Feature/Responsibility';
import ManagementCapability from '../../NativeDevice/Management/ManagementCapability';
import IPolicyCheckAndSetProperties from '../Device/Policy/IPolicyCheckAndSetProperties';
import { CheckAndSetResult, createDevicePolicySaga } from '../Device/Policy/devicePolicySagas';
import { getExtendedManagementTelemetry } from './extendedManagementTelemetrySagas';

export const deviceExtendedManagementPolicySaga = createDevicePolicySaga(
	DeviceSettingsType.EXTENDED_MANAGEMENT,
	Responsibility.EXTENDED_MANAGEMENT,
	ManagementCapability.EXTENDED_MANAGEMENT,
	checkAndSetExtendedManagementSettings,
);

export async function* checkAndSetExtendedManagementSettings(
	properties: IPolicyCheckAndSetProperties<DeviceSettingsType.EXTENDED_MANAGEMENT>,
) {
	const { url: currentUrl } = await getExtendedManagementTelemetry(properties);
	const { policy, managementDriver } = properties;
	if (policy.value === undefined) {
		return CheckAndSetResult.NOT_CHANGED;
	}
	const proposedUrl = policy.value.url;
	if (currentUrl !== proposedUrl) {
		await managementDriver.setExtendedManagementUrl(proposedUrl);
		return CheckAndSetResult.CHANGED;
	}
	return CheckAndSetResult.NOT_CHANGED;
}
