import { bindAndTakeEvery } from '../../Socket/socketActionCreator';
import { AuthenticationSucceed } from '@signageos/actions/dist/Authentication/authenticationActions';
import IManagementDriver from '../../NativeDevice/Management/IManagementDriver';
import IBasicDriver from '../../NativeDevice/IBasicDriver';
import { IResponsibilities } from '../../Feature/Responsibilities';
import Responsibility from '../../Feature/Responsibility';
import { notifyDeviceApplicationVersionCommon, notifyDeviceInfo, notifyDeviceProxyInfo } from '../../Device/deviceSagas';

export function* notifyDeviceSaga(getNativeDriver: () => IManagementDriver, responsibilities: IResponsibilities) {
	if (responsibilities.has(Responsibility.DEVICE)) {
		yield bindAndTakeEvery(AuthenticationSucceed, notifyDeviceInfo, getNativeDriver);
	}
	if (responsibilities.has(Responsibility.PROXY)) {
		yield bindAndTakeEvery(AuthenticationSucceed, notifyDeviceProxyInfo, getNativeDriver);
	}
}

export function* notifyDeviceApplicationVersion(
	getNativeDriver: () => IBasicDriver,
	responsibilities: IResponsibilities,
	applicationVersion: string,
) {
	if (!responsibilities.has(Responsibility.APP)) {
		return;
	}

	yield bindAndTakeEvery(AuthenticationSucceed, notifyDeviceApplicationVersionCommon, getNativeDriver, applicationVersion);
}
