import { LongWeekdayNativeTimer, LongWeekdayProprietaryTimer } from '@signageos/common-types/dist/Device/Settings/DeviceSettings';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import { convertWeekday } from '@signageos/lib/dist/Timer/convertWeekday';
import Responsibility from '../../../Feature/Responsibility';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import IGetTelemetryProperties from '../Telemetry/IGetTelemetryProperties';
import { createDeviceTelemetrySaga } from '../Telemetry/deviceTelemetrySagas';
import { numberToNativeTimerType } from '../../../NativeDevice/Timer/TimerType';

export const telemetryDeviceTimerSaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.TIMERS,
	Responsibility.TIMERS,
	[ManagementCapability.TIMERS_NATIVE],
	getNativeTimers,
);

export const telemetryDeviceProprietaryTimerSaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.PROPRIETARY_TIMERS,
	Responsibility.TIMERS,
	[ManagementCapability.TIMERS_PROPRIETARY],
	getProprietaryTimers,
);

export async function getNativeTimers({ managementDriver }: IGetTelemetryProperties): Promise<LongWeekdayNativeTimer[]> {
	const timers = await managementDriver.getTimers();
	return timers.map((timer) => ({
		type: numberToNativeTimerType(timer.type),
		timeOn: typeof timer.timeOn === 'string' ? timer.timeOn.replace(/^(\d{2}):(\d{2}).*/, '$1:$2:00') : null,
		timeOff: typeof timer.timeOff === 'string' ? timer.timeOff.replace(/^(\d{2}):(\d{2}).*/, '$1:$2:00') : null,
		weekdays: convertWeekday.fromTimerWeekday(timer.weekdays).toLong(),
		volume: timer.volume,
	}));
}
export async function getProprietaryTimers({ timerStorage }: IGetTelemetryProperties): Promise<LongWeekdayProprietaryTimer[]> {
	const timers = await timerStorage.getShortTimers();
	return Object.values(timers).map((t) => ({ ...t, weekdays: convertWeekday.fromShort(t.weekdays).toLong() }));
}
