import { createDeviceTelemetrySaga } from '../Telemetry/deviceTelemetrySagas';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import IGetTelemetryProperties from '../Telemetry/IGetTelemetryProperties';
import { MonitoringLogData } from '@signageos/common-types/dist/Device/MonitoringLog/MonitoringLogData';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import Responsibility from '../../../Feature/Responsibility';

export const telemetryTemperatureSettingsSaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.TEMPERATURE,
	Responsibility.TEMPERATURE,
	[ManagementCapability.TEMPERATURE],
	getTemperatureSettings,
);

export async function getTemperatureSettings({
	managementDriver,
}: IGetTelemetryProperties): Promise<MonitoringLogData[DeviceTelemetryType.TEMPERATURE]> {
	const temperature = await managementDriver.getCurrentTemperature();
	return { temperature: temperature };
}
