import { put, fork } from 'redux-saga/effects';
import { RecordTemperature } from '@signageos/actions/dist/Device/Temperature/deviceTemperatureActions';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import { IResponsibilities } from '../../../Feature/Responsibilities';
import Responsibility from '../../../Feature/Responsibility';
import { whenCapable } from '../../../Feature/capable';
import { withDependencies } from '../../../DI/dependencyInjection';
import { registerTelemetry } from '../Telemetry/deviceTelemetryHelper';

export function* deviceTemperatureSaga(responsibilities: IResponsibilities) {
	if (!responsibilities.has(Responsibility.TEMPERATURE)) {
		return;
	}

	yield fork(
		whenCapable(
			ManagementCapability.TEMPERATURE,
			withDependencies(['managementDriver', 'telemetryIntervals'], function* ({ managementDriver, telemetryIntervals }) {
				const periodMs = telemetryIntervals?.temperature ?? 0;
				yield registerTelemetry('TEMPERATURE', periodMs, function* () {
					try {
						const temperature: number = yield managementDriver.getCurrentTemperature();
						yield put({
							type: RecordTemperature,
							temperature,
						} as RecordTemperature);
					} catch (error) {
						console.error('deviceTemperatureSaga', error);
					}
				});
			}),
		),
	);
}
