import { put } from 'redux-saga/effects';
import { createChannel, takeEvery as takeEventChannelMessage } from '../../../ReduxSaga/channels';
import IManagementDriver from '../../../NativeDevice/Management/IManagementDriver';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import { IStorageUnit } from '../../../NativeDevice/fileSystem';
import { NotifyStorageStatus } from '@signageos/actions/dist/Device/Storage/storageActions';
import Responsibility from '../../../Feature/Responsibility';
import { withDependencies } from '../../../DI/dependencyInjection';
import { SubscriptionType } from '../../../Display/IConfig';
import { whenResponsible } from '../../../Feature/responsible';
import { whenCapable } from '../../../Feature/capable';
import { registerTelemetry } from '../Telemetry/deviceTelemetryHelper';

export const createDeviceStorageSaga = () =>
	whenResponsible(
		Responsibility.STORAGE,
		whenCapable(
			ManagementCapability.STORAGE_UNITS,
			withDependencies(
				['managementDriver', 'subscriptionType', 'telemetryIntervals'],
				function* ({ managementDriver, subscriptionType, telemetryIntervals }) {
					const periodMs = telemetryIntervals?.storage ?? 0;
					yield registerTelemetry('STORAGE', periodMs, function* () {
						try {
							yield updateStorageStatus(managementDriver);
						} catch (error) {
							console.error('deviceStorageSaga', error);
						}
					});

					const storageChangesChannel = createChannel<undefined>((putHere: (message: undefined) => void) =>
						managementDriver.fileSystem.onStorageUnitsChanged(() => putHere(undefined)),
					);
					yield takeEventChannelMessage(storageChangesChannel, function* () {
						try {
							if (subscriptionType === SubscriptionType.platform) {
								yield updateStorageStatus(managementDriver);
							}
						} catch (error) {
							console.error('deviceStorageSaga', error);
						}
					});
				},
			),
		),
	);

function* updateStorageStatus(nativeDriver: IManagementDriver) {
	const storageUnits: IStorageUnit[] = yield nativeDriver.fileSystem.listStorageUnits();
	yield put({
		type: NotifyStorageStatus,
		storageStatus: {
			storageUnits,
		},
	} as NotifyStorageStatus);
}
