import { createDeviceTelemetrySaga } from '../Telemetry/deviceTelemetrySagas';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import IGetTelemetryProperties from '../Telemetry/IGetTelemetryProperties';
import Responsibility from '../../../Feature/Responsibility';

export const telemetryResolutionSaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.RESOLUTION,
	Responsibility.SCREEN,
	[],
	getResolutionSettings,
);

export async function getResolutionSettings({ managementDriver }: IGetTelemetryProperties) {
	return await managementDriver.getResolution();
}
