import { createDeviceTelemetrySaga } from '../Telemetry/deviceTelemetrySagas';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import IGetTelemetryProperties from '../Telemetry/IGetTelemetryProperties';
import Responsibility from '../../../Feature/Responsibility';

export const telemetryOrientationSaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.ORIENTATION,
	Responsibility.SCREEN,
	[],
	getOrientationSettings,
);

export async function getOrientationSettings({ managementDriver }: IGetTelemetryProperties) {
	return {
		orientation: await managementDriver.getCurrentOrientation(),
	};
}
