import { createDeviceTelemetrySaga } from '../Telemetry/deviceTelemetrySagas';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import Responsibility from '../../../Feature/Responsibility';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import IGetTelemetryProperties from '../Telemetry/IGetTelemetryProperties';
import { ProxySettings } from '@signageos/common-types/dist/Device/Settings/DeviceSettings';

export const telemetryDeviceProxySaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.PROXY,
	Responsibility.PROXY,
	[ManagementCapability.PROXY],
	getProxySettings,
);

export async function getProxySettings({ managementDriver }: IGetTelemetryProperties) {
	const proxySettings: ProxySettings = {
		enabled: await managementDriver.proxy.isEnabled(),
		uri: (await managementDriver.proxy.getConnectedTo()) || null,
	};
	return proxySettings;
}
