import PowerActionType from '@signageos/common-types/dist/Device/Power/PowerActionType';
import ActionsPowerActionType from '@signageos/actions/dist/Device/Power/PowerActionType';
import wait from '@signageos/lib/dist/Timer/wait';
import { OfflineActionsUploader } from '../../../Offline/OfflineActionsUploader';
import { SystemLog } from '@signageos/actions/dist/SystemLog/systemLogActions';
import IOfflineAction from '@signageos/actions/dist/IOfflineAction';
import { fileSystemWipeoutAction } from '../../managementHelper';
import { PowerKernel } from './PowerKernel';
import { ManagementCacheDriver, normalizeManagementCacheDriver } from '../../../NativeDevice/Default/combinedDriver';
import { PowerActionPerformed } from '@signageos/common-types/dist/Device/SystemLogs/systemLogs';

export class PowerFacade {
	constructor(
		private nativeDriver: ManagementCacheDriver,
		private actionUploader: OfflineActionsUploader,
		private powerKernel: PowerKernel,
	) {}

	public async performPowerAction(powerType: ActionsPowerActionType) {
		const { managementDriver, cacheDriver } = normalizeManagementCacheDriver(this.nativeDriver);
		const powerAction: SystemLog & IOfflineAction = {
			type: SystemLog,
			payload: {
				type: PowerActionPerformed,
				action: ActionsPowerActionType[powerType] as PowerActionType,
			},
			__dispatchedAt: new Date(),
			__offline: true,
		};
		// In this case we cannot listen to succeed action because power action is trigger so we append action directly to offlineAction file
		await this.actionUploader.addAction(powerAction);
		switch (powerType) {
			case ActionsPowerActionType.APP_RESTART:
				await this.powerKernel.appRestart();
				return true;
			case ActionsPowerActionType.SYSTEM_REBOOT:
				await this.powerKernel.systemReboot();
				return true;
			case ActionsPowerActionType.DISPLAY_POWER_ON:
				await managementDriver.displayPowerOn();
				return true;
			case ActionsPowerActionType.DISPLAY_POWER_OFF:
				await managementDriver.displayPowerOff();
				return true;
			case ActionsPowerActionType.FILE_SYSTEM_WIPEOUT:
				await fileSystemWipeoutAction(managementDriver, cacheDriver);
				await wait(1e3);
				await this.powerKernel.systemReboot();
				return true;
			default:
				return false;
		}
	}
}
