import { PowerActionsScheduleSettings } from '@signageos/common-types/dist/Device/Settings/DeviceSettings';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import CommonPowerActionType from '@signageos/common-types/dist/Device/Power/PowerActionType';
import { createDeviceTelemetrySaga } from '../Telemetry/deviceTelemetrySagas';
import IGetTelemetryProperties from '../Telemetry/IGetTelemetryProperties';
import CommonWeekday from '@signageos/common-types/dist/Device/Time/Weekday';
import PowerActionType from '@signageos/actions/dist/Device/Power/PowerActionType';
import Weekday from '@signageos/actions/dist/Misc/Weekday';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import Responsibility from '../../../Feature/Responsibility';

export const telemetryDevicePowerActionsSaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.POWER_ACTIONS_SCHEDULE,
	Responsibility.SCHEDULED_POWER,
	[ManagementCapability.SCHEDULE_POWER_ACTION],
	getPowerActionsScheduleSettings,
);

export async function getPowerActionsScheduleSettings({
	powerActionRules,
}: IGetTelemetryProperties): Promise<PowerActionsScheduleSettings[]> {
	const scheduledActions = await powerActionRules();

	return Object.keys(scheduledActions).map((uid: string) => {
		const powerAction = scheduledActions[uid];
		return {
			uid,
			powerType: CommonPowerActionType[PowerActionType[powerAction.powerType] as keyof typeof CommonPowerActionType],
			weekdays: powerAction.weekdays.map((weekday: Weekday) => CommonWeekday[Weekday[weekday] as keyof typeof CommonWeekday]),
			time: powerAction.time,
		};
	});
}
