import IManagementDriver from '../../../NativeDevice/Management/IManagementDriver';

export interface PowerControl {
	appRestart(): Promise<void>;
	systemReboot(): Promise<void>;
	doBeforeShutDown(callback: () => Promise<void>): void;
}

export class PowerKernel implements PowerControl {
	private _callbacks: Array<() => Promise<void>> = [];

	constructor(private managementDriver: IManagementDriver) {}

	public doBeforeShutDown(callback: () => Promise<void>) {
		this._callbacks?.push(callback);
	}

	public async appRestart() {
		await this.runCallbacks();
		return await this.managementDriver.appRestart();
	}

	public async systemReboot() {
		await this.runCallbacks();
		return await this.managementDriver.systemReboot();
	}

	private async runCallbacks() {
		try {
			return await Promise.all(
				this._callbacks?.map(async (callback) => {
					return await callback();
				}),
			);
		} catch (error) {
			console.error('Error when calling callback before shutDown', error);
		}
	}
}
