import PowerActionType from '@signageos/actions/dist/Device/Power/PowerActionType';
import { PowerFacade } from './powerFacade';
import IPowerActionExecutor from '../../../NativeDevice/Power/IPowerActionExecutor';
import Debug from 'debug';

const debug = Debug('@signageos/front-display:NativeDevice:Power:ManagementPowerActionExecutor');

export default class ManagementPowerActionExecutor implements IPowerActionExecutor {
	constructor(private powerActions: PowerFacade) {}

	public execute(powerAction: PowerActionType): void {
		new Promise<void>(async (resolve: () => void, reject: (error: Error) => void) => {
			const success = await this.powerActions.performPowerAction(powerAction);
			if (success) {
				resolve();
			} else {
				reject(new Error(`Unsupported power action: ${powerAction}`));
			}
		}).catch((reason: any) => {
			debug(`Failed to perform scheduled power action: ${reason}`);
		});
	}
}
