import { createDeviceTelemetrySaga } from '../Telemetry/deviceTelemetrySagas';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import IGetTelemetryProperties from '../Telemetry/IGetTelemetryProperties';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import Responsibility from '../../../Feature/Responsibility';

export const telemetryDevicePeerRecoverySaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.PEER_RECOVERY,
	Responsibility.PEER_RECOVERY,
	[ManagementCapability.PEER_RECOVERY],
	getPeerRecoverySetting,
);

export async function getPeerRecoverySetting({ managementDriver }: IGetTelemetryProperties) {
	return await managementDriver.getPeerRecovery();
}
