import { DeviceSettingsType } from '@signageos/common-types/dist/Device/Settings/DeviceSettingsType';
import { CheckAndSetResult, createDevicePolicySaga } from '../Policy/devicePolicySagas';
import Responsibility from '../../../Feature/Responsibility';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import { getPeerRecoverySetting } from './peerRecoveryTelemetrySaga';
import IPolicyCheckAndSetProperties from '../Policy/IPolicyCheckAndSetProperties';
import processCallback from '../../../Util/processCallback';

export const devicePeerRecoveryPolicySaga = createDevicePolicySaga(
	DeviceSettingsType.PEER_RECOVERY,
	Responsibility.PEER_RECOVERY,
	ManagementCapability.PEER_RECOVERY,
	checkAndSetPeerRecoverySettings,
);

export async function* checkAndSetPeerRecoverySettings(properties: IPolicyCheckAndSetProperties<DeviceSettingsType.PEER_RECOVERY>) {
	const peerRecoverySetting = properties.policy.value;
	const currentPeerRecoverySettings = await getPeerRecoverySetting(properties);

	if (peerRecoverySetting !== currentPeerRecoverySettings) {
		const finalizeCallback = await setPeerRecovery(properties, peerRecoverySetting);
		processCallback(finalizeCallback);
		return CheckAndSetResult.CHANGED;
	}

	return CheckAndSetResult.NOT_CHANGED;
}

async function setPeerRecovery(properties: IPolicyCheckAndSetProperties<DeviceSettingsType.PEER_RECOVERY>, peerRecoverySetting: any) {
	if (peerRecoverySetting.enabled && peerRecoverySetting.urlLauncherAddress) {
		return properties.managementDriver.setPeerRecovery({
			enabled: true,
			urlLauncherAddress: peerRecoverySetting.urlLauncherAddress,
		});
	} else {
		return properties.managementDriver.setPeerRecovery({
			enabled: false,
			autoEnableTimeoutMs: peerRecoverySetting.autoEnableTimeoutMs,
		});
	}
}
