import { bindWhenPlatform } from '../../../Socket/socketActionCreator';
import { apply, fork, put, takeEvery } from 'redux-saga/effects';
import { InstallPackage, InstallPackageSucceeded, InstallPackageFailed } from '@signageos/actions/dist/Device/Package/devicePackageActions';
import IManagementDriver from '../../../NativeDevice/Management/IManagementDriver';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import { IResponsibilities } from '../../../Feature/Responsibilities';
import Responsibility from '../../../Feature/Responsibility';
import { whenCapable } from '../../../Feature/capable';
import { withDependencies } from '../../../DI/dependencyInjection';

function* installPackageCallback(managementDriver: IManagementDriver, staticBaseUrl: string, action: InstallPackage) {
	try {
		yield apply(managementDriver, managementDriver.packageInstall, [staticBaseUrl!, action.packageName, action.version, action.build!]);
		yield put({
			type: InstallPackageSucceeded,
			uid: action.uid,
		} as InstallPackageSucceeded);
	} catch (error) {
		console.error('installPackageSaga', error);
		yield put({
			type: InstallPackageFailed,
			uid: action.uid,
		} as InstallPackageFailed);
	}
}

export function* installPackageSaga(responsibilities: IResponsibilities) {
	if (!responsibilities.has(Responsibility.PACKAGES)) {
		return;
	}

	yield bindWhenPlatform(InstallPackage);

	yield fork(
		whenCapable(
			ManagementCapability.PACKAGE_INSTALL,
			withDependencies(['managementDriver', 'staticBaseUrl'], function* ({ managementDriver, staticBaseUrl }) {
				yield takeEvery(InstallPackage, installPackageCallback, managementDriver, staticBaseUrl);
			}),
		),
	);
}
