import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import Responsibility from '../../../Feature/Responsibility';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import { createDeviceTelemetrySaga } from '../Telemetry/deviceTelemetrySagas';
import IGetTelemetryProperties from '../Telemetry/IGetTelemetryProperties';
import { NetworkInterfaces } from '@signageos/common-types/dist/Device/Network/NetworkInterface';

export const telemetryDeviceWifiStrenghtSaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.WIFI_STRENGTH,
	Responsibility.WIFI_STRENGTH,
	[ManagementCapability.WIFI_STRENGTH],
	getWifiSettings,
);

export async function getWifiSettings({ managementDriver }: IGetTelemetryProperties) {
	const networkInterfaces: NetworkInterfaces[] = await managementDriver.network.listInterfaces();
	const networkInterface = networkInterfaces.find(({ type }: NetworkInterfaces) => type === 'wifi');

	if (networkInterface && 'wifiStrength' in networkInterface) {
		return {
			strength: networkInterface.wifiStrength || 0,
		};
	}

	return {
		strength: 0,
	};
}
