import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import Responsibility from '../../../Feature/Responsibility';
import { createDeviceTelemetrySaga } from '../Telemetry/deviceTelemetrySagas';
import IGetTelemetryProperties from '../Telemetry/IGetTelemetryProperties';
import { ManagementCapabilities } from '@signageos/common-types/dist/Device/Capabilities/ManagementCapabilities';

export const telemetryNetworkInfo = createDeviceTelemetrySaga(
	DeviceTelemetryType.NETWORK_INTERFACES,
	Responsibility.NETWORK,
	[ManagementCapabilities.NETWORK_INFO],
	getNetworkInfo,
);

export async function getNetworkInfo({ managementDriver }: IGetTelemetryProperties) {
	const networkInterfaces = await managementDriver.network.listInterfaces();
	return networkInterfaces;
}
