import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import Responsibility from '../../../Feature/Responsibility';
import { createDeviceTelemetrySaga } from '../Telemetry/deviceTelemetrySagas';
import IGetTelemetryProperties from '../Telemetry/IGetTelemetryProperties';

export const telemetryDeviceFirmwareSaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.FIRMWARE_VERSION,
	Responsibility.FIRMWARE,
	[],
	getFirmwareVersionSettings,
);

export async function getFirmwareVersionSettings({ managementDriver }: IGetTelemetryProperties) {
	return { version: await managementDriver.firmwareGetVersion() };
}
