import { DeviceSettingsType } from '@signageos/common-types/dist/Device/Settings/DeviceSettingsType';
import IPolicyCheckAndSetProperties from '../Policy/IPolicyCheckAndSetProperties';
import { getFirmwareVersionSettings } from './deviceFirmwareTelemetrySagas';
import { CheckAndSetResult, createDevicePolicySaga } from '../Policy/devicePolicySagas';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import Responsibility from '../../../Feature/Responsibility';
import processCallback from '../../../Util/processCallback';

export const deviceFirmwarePolicySaga = createDevicePolicySaga(
	DeviceSettingsType.FIRMWARE_VERSION,
	Responsibility.FIRMWARE,
	ManagementCapability.FIRMWARE_UPGRADE,
	checkAndSetFirmwareVersionSettings,
);

export async function* checkAndSetFirmwareVersionSettings(properties: IPolicyCheckAndSetProperties<DeviceSettingsType.FIRMWARE_VERSION>) {
	const firmwareVersionSettings = properties.policy.value;
	const currentFirmwareVersionSettings = await getFirmwareVersionSettings(properties);
	if (currentFirmwareVersionSettings.version !== firmwareVersionSettings.version) {
		const finalizeCallback = await properties.managementDriver.firmwareUpgrade(
			properties.getStaticBaseUrl(),
			firmwareVersionSettings.version,
		);
		processCallback(finalizeCallback);
		return CheckAndSetResult.CHANGED;
	}
	return CheckAndSetResult.NOT_CHANGED;
}
