import { fork } from 'redux-saga/effects';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import Responsibility from '../../../Feature/Responsibility';
import { runPeriodicTaskSagaUntilSuccessWhilePlatform } from '../../../Saga/periodicTaskSaga';
import { whenResponsible } from '../../../Feature/responsible';
import { whenCapable } from '../../../Feature/capable';
import { withDependencies } from '../../../DI/dependencyInjection';
import { putExperimental } from '../../../Experimental/experimentalActions';

const ConnectedDisplayOverSerial = 'DisplayManager.ConnectedDisplayOverSerial';
interface ConnectedDisplayOverSerial {
	type: typeof ConnectedDisplayOverSerial;
	display: string;
	success: boolean;
}

export const displayManagerSaga = whenResponsible(
	Responsibility.DISPLAY_MANAGER,
	whenCapable(ManagementCapability.DISPLAY_MANAGER, displayManagerSagaDefault),
);

function* displayManagerSagaDefault() {
	yield fork(
		whenCapable(
			ManagementCapability.DISPLAY_MANAGER,
			withDependencies(['managementDriver'], function* ({ managementDriver }) {
				yield runPeriodicTaskSagaUntilSuccessWhilePlatform(10e3, 60e3, function* (): IterableIterator<any> {
					const connectedDisplay = yield managementDriver.displayManager.getConnectedDisplay();
					const isSerialConnectionAvailable = yield managementDriver.displayManager.isSerialConnectionAvailable();
					if (connectedDisplay) {
						//TODO: Change to systemLogs when will be working again
						yield putExperimental({
							type: ConnectedDisplayOverSerial,
							display: connectedDisplay,
							success: isSerialConnectionAvailable,
						});
					}
				});
			}),
		),
	);
}
