import { createDeviceTelemetrySaga } from '../Telemetry/deviceTelemetrySagas';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import IGetTelemetryProperties from '../Telemetry/IGetTelemetryProperties';
import { getCurrentTime } from './dateTimeFacade';
import Responsibility from '../../../Feature/Responsibility';

export const telemetryDeviceDateTimeSaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.DATETIME,
	Responsibility.TIME,
	[],
	getDateTimeSettings,
);

export async function getDateTimeSettings({ managementDriver }: IGetTelemetryProperties) {
	const currentTime = await getCurrentTime(managementDriver);
	return {
		timezone: currentTime.timezone || null,
		ntpServer: currentTime.ntpServer || null,
	};
}
