import { createDeviceTelemetrySaga } from '../Telemetry/deviceTelemetrySagas';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import Responsibility from '../../../Feature/Responsibility';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import IGetTelemetryProperties from '../Telemetry/IGetTelemetryProperties';
import { MonitoringLogData } from '@signageos/common-types/dist/Device/MonitoringLog/MonitoringLogData';

export const telemetryManagementCapabilitiesSaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.MANAGEMENT_CAPABILITIES,
	Responsibility.CAPABILITIES_MANAGEMENT,
	[],
	getSupportedCapabilities,
);

export async function getSupportedCapabilities({ managementDriver }: IGetTelemetryProperties) {
	const supportedCapabilities: ManagementCapability[] = [];
	for (const capability of Object.values(ManagementCapability)) {
		const supports: boolean = await managementDriver.managementSupports(capability);
		if (supports) {
			supportedCapabilities.push(capability);
		}
	}
	const isCapable: MonitoringLogData[DeviceTelemetryType.MANAGEMENT_CAPABILITIES] = {
		capable: supportedCapabilities,
	};

	return isCapable;
}
