import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import Responsibility from '../../../Feature/Responsibility';
import { createDeviceTelemetrySaga } from '../Telemetry/deviceTelemetrySagas';
import { awaitDependencies } from '../../../DI/dependencyInjection';
import { IBundledApplet } from '../../../Front/Applet/BundledApplet/bundledAppletActions';
import { SagaIterator } from 'redux-saga';

export function* getBundledAppletInfo() {
	let bundledAppletInfo: IBundledApplet | null = null;
	const { bundledApplet: bundledApplet } = yield awaitDependencies(['bundledApplet']);
	bundledAppletInfo = bundledApplet;
	if (!bundledAppletInfo) {
		return null;
	}
	return {
		appletUid: bundledAppletInfo.uid,
		appletVersion: bundledAppletInfo.version,
		config: bundledAppletInfo.config ?? {},
	};
}

export const telemetryDeviceBundledAppletSaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.BUNDLED_APPLET,
	Responsibility.BUNDLED_APPLET,
	[],
	function* () {
		return yield* getBundledAppletInfo() as unknown as Generator<SagaIterator, IBundledApplet>;
	},
);
