import { createDeviceTelemetrySaga } from '../Telemetry/deviceTelemetrySagas';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import IGetTelemetryProperties from '../Telemetry/IGetTelemetryProperties';
import { BrightnessSettings } from '@signageos/common-types/dist/Device/Settings/DeviceSettings';
import { resolveCurrentBrightness } from '../../../NativeDevice/Screen/screenHelper';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import Responsibility from '../../../Feature/Responsibility';

export const telemetryBrightnessSettingsSaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.BRIGHTNESS,
	Responsibility.BRIGHTNESS,
	[ManagementCapability.GET_BRIGHTNESS],
	getBrightnessSettings,
);

export async function getBrightnessSettings(
	{ managementDriver }: IGetTelemetryProperties,
	time: Date = new Date(),
): Promise<BrightnessSettings> {
	const { timeFrom1, brightness1, timeFrom2, brightness2 } = await managementDriver.screenGetBrightness();
	return {
		brightness: resolveCurrentBrightness(timeFrom1, brightness1, timeFrom2, brightness2, time),
	};
}
