import { DeviceSettingsType } from '@signageos/common-types/dist/Device/Settings/DeviceSettingsType';
import { CheckAndSetResult, createDevicePolicySaga } from '../Policy/devicePolicySagas';
import { getBrightnessSettings } from './brightnessTelemetrySagas';
import { resolveCurrentBrightness } from '../../../NativeDevice/Screen/screenHelper';
import IPolicyCheckAndSetProperties from '../Policy/IPolicyCheckAndSetProperties';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import Responsibility from '../../../Feature/Responsibility';

export const deviceBrightnessPolicySaga = createDevicePolicySaga(
	DeviceSettingsType.BRIGHTNESS,
	Responsibility.BRIGHTNESS,
	ManagementCapability.SET_BRIGHTNESS,
	checkAndSetBrightnessSettings,
);

export async function* checkAndSetBrightnessSettings(properties: IPolicyCheckAndSetProperties<DeviceSettingsType.BRIGHTNESS>) {
	const { brightness: currentBrightnessSettings } = await getBrightnessSettings(properties);
	const { policy, managementDriver } = properties;
	if (policy.value === undefined) {
		return CheckAndSetResult.NOT_CHANGED;
	}
	const proposedBrightnessSettings = resolveCurrentBrightness(
		policy.value[0].time,
		policy.value[0].brightness,
		policy.value[1]?.time ?? policy.value[0].time,
		policy.value[1]?.brightness ?? policy.value[0].brightness,
		new Date(),
	);
	if (currentBrightnessSettings !== proposedBrightnessSettings) {
		await managementDriver.screenSetBrightness(
			policy.value[0].time,
			policy.value[0].brightness,
			policy.value[1]?.time ?? policy.value[0].time,
			policy.value[1]?.brightness ?? policy.value[0].brightness,
		);
		return CheckAndSetResult.CHANGED;
	}
	return CheckAndSetResult.NOT_CHANGED;
}
