import { createDeviceTelemetrySaga } from '../Telemetry/deviceTelemetrySagas';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import IGetTelemetryProperties from '../Telemetry/IGetTelemetryProperties';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import Responsibility from '../../../Feature/Responsibility';

export const telemetryDeviceVolumeSaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.VOLUME,
	Responsibility.VOLUME,
	[ManagementCapability.GET_VOLUME],
	getVolumeSettings,
);

export async function getVolumeSettings({ managementDriver }: IGetTelemetryProperties) {
	return {
		volume: await managementDriver.getVolume(),
	};
}
