import { bindWhenPlatform } from '../../../Socket/socketActionCreator';
import { put, apply, takeEvery } from 'redux-saga/effects';
import { SetDeviceVolume, SetDeviceVolumeSucceeded, SetDeviceVolumeFailed } from '@signageos/actions/dist/Device/Audio/deviceAudioActions';
import IManagementDriver from '../../../NativeDevice/Management/IManagementDriver';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import { IResponsibilities } from '../../../Feature/Responsibilities';
import Responsibility from '../../../Feature/Responsibility';

export function* setDeviceVolumeCallback(getNativeDriver: () => IManagementDriver, action: SetDeviceVolume) {
	try {
		const nativeDriver = getNativeDriver();

		yield apply(nativeDriver, nativeDriver.setVolume, [action.volume]);
		yield put({
			type: SetDeviceVolumeSucceeded,
			uid: action.uid,
		} as SetDeviceVolumeSucceeded);
	} catch (error) {
		console.error('deviceVolumeSaga', error);
		yield put({
			type: SetDeviceVolumeFailed,
			uid: action.uid,
		} as SetDeviceVolumeFailed);
	}
}

export function* deviceVolumeSaga(getNativeDriver: () => IManagementDriver, responsibilities: IResponsibilities) {
	if (!responsibilities.has(Responsibility.VOLUME)) {
		return;
	}

	yield bindWhenPlatform(SetDeviceVolume);

	const supportsVolume: boolean = yield getNativeDriver().managementSupports(ManagementCapability.SET_VOLUME);
	if (supportsVolume) {
		yield takeEvery(SetDeviceVolume, setDeviceVolumeCallback, getNativeDriver);
	}
}
