import { createDeviceTelemetrySaga } from '../Telemetry/deviceTelemetrySagas';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import IGetTelemetryProperties from '../Telemetry/IGetTelemetryProperties';
import Responsibility from '../../../Feature/Responsibility';

export const telemetryDeviceApplicationSaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.APPLICATION_VERSION,
	Responsibility.APP,
	[],
	getApplicationVersion,
);

export async function getApplicationVersion({ applicationVersion }: IGetTelemetryProperties) {
	return { version: applicationVersion };
}
