import { bindWhenPlatform } from '../../../Socket/socketActionCreator';
import { call, apply, put, takeEvery, fork } from 'redux-saga/effects';
import {
	SetDeviceApplicationVersion,
	SetDeviceApplicationVersionSucceeded,
	SetDeviceApplicationVersionFailed,
} from '@signageos/actions/dist/Device/Application/deviceApplicationActions';
import IManagementDriver from '../../../NativeDevice/Management/IManagementDriver';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import { IResponsibilities } from '../../../Feature/Responsibilities';
import Responsibility from '../../../Feature/Responsibility';
import { whenCapable } from '../../../Feature/capable';
import { withDependencies } from '../../../DI/dependencyInjection';
import processCallback, { ICallback } from '../../../Util/processCallback';

export function* setDeviceApplicationVersionCallback(
	managementDriver: IManagementDriver,
	staticBaseUrl: string,
	action: SetDeviceApplicationVersion,
) {
	try {
		const finalizeCallback: ICallback = yield apply(managementDriver, managementDriver.appUpgrade, [staticBaseUrl, action.version]);
		yield put({
			type: SetDeviceApplicationVersionSucceeded,
			uid: action.uid,
		} as SetDeviceApplicationVersionSucceeded);
		yield call(processCallback, finalizeCallback);
	} catch (error) {
		console.error('syncApplicationVersionSaga', error);
		yield put({
			type: SetDeviceApplicationVersionFailed,
			uid: action.uid,
		} as SetDeviceApplicationVersionFailed);
	}
}

export function* syncApplicationVersionSaga(responsibilities: IResponsibilities) {
	if (!responsibilities.has(Responsibility.APP)) {
		return;
	}

	yield bindWhenPlatform(SetDeviceApplicationVersion);

	yield fork(
		whenCapable(
			ManagementCapability.APP_UPGRADE,
			withDependencies(['managementDriver', 'staticBaseUrl'], function* ({ managementDriver, staticBaseUrl }) {
				yield takeEvery(SetDeviceApplicationVersion, setDeviceApplicationVersionCallback, managementDriver, staticBaseUrl);
			}),
		),
	);
}
