import { DeviceSettingsType } from '@signageos/common-types/dist/Device/Settings/DeviceSettingsType';
import { CheckAndSetResult, createDevicePolicySaga } from '../Policy/devicePolicySagas';
import IPolicyCheckAndSetProperties from '../Policy/IPolicyCheckAndSetProperties';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import Responsibility from '../../../Feature/Responsibility';
import processCallback from '../../../Util/processCallback';

export const deviceApplicationPolicySaga = createDevicePolicySaga(
	DeviceSettingsType.APPLICATION_VERSION,
	Responsibility.APP,
	ManagementCapability.APP_UPGRADE,
	checkAndSetApplicationVersionSettings,
);

export async function* checkAndSetApplicationVersionSettings({
	policy,
	managementDriver,
	getStaticBaseUrl,
	applicationVersion,
}: IPolicyCheckAndSetProperties<DeviceSettingsType.APPLICATION_VERSION>) {
	const applicationVersionSettings = policy.value;
	if (applicationVersion !== applicationVersionSettings.version) {
		const finalizeCallback = await managementDriver.appUpgrade(getStaticBaseUrl(), applicationVersionSettings.version);
		processCallback(finalizeCallback);
		return CheckAndSetResult.CHANGED;
	}
	return CheckAndSetResult.NOT_CHANGED;
}
