import AsyncLock from 'async-lock';
import CircularJSON from 'circular-json';

export interface IOptions {
	timeout?: number;
	maxPending?: number;
	domainReentrant?: boolean;
}

export function synchronous(options?: IOptions) {
	const asyncLock = new AsyncLock(options);
	return function (_target: any, propertyKey: string, descriptor: PropertyDescriptor) {
		const originalMethod = descriptor.value;
		descriptor.value = function (...args: any[]) {
			return asyncLock.acquire(propertyKey, async () => {
				const returnValuePromise = originalMethod.apply(this, args);
				if (!(returnValuePromise instanceof Promise)) {
					throw new Error(`Synchronous methods must return Promise instance. But ${CircularJSON.stringify(returnValuePromise)} given.`);
				}
				const returnValue = await returnValuePromise;
				return returnValue;
			});
		};
	};
}
