import Debug from 'debug';
import { IInput } from '../NativeDevice/Input/IInput';
import { MouseEventPayload, EventPayload as RemoteDesktopEvent } from '@signageos/remote-desktop/es6/RemoteDesktop/messages';
const debug = Debug('@signageos/front-display:Input:ProprietaryInput');

export class ProprietaryInput implements IInput {
	constructor(private readonly window: Window) {}

	public async dispatchEvent(event: RemoteDesktopEvent): Promise<void> {
		debug('dispatchEvent', { event });

		if (isMouseEventPayload(event)) {
			let view = this.window;
			let element = this.window.document.elementFromPoint(event.x, event.y);

			// Go through iframes to the deepest element
			while (isHTMLIframeElement(element) && element.contentWindow) {
				event = {
					...event,
					x: event.x - element.offsetLeft,
					y: event.y - element.offsetTop,
				};
				view = element.contentWindow;
				element = element.contentWindow.document.elementFromPoint(event.x, event.y);
			}

			const effective = element?.dispatchEvent(
				new MouseEvent(event.type, {
					view,
					bubbles: true,
					cancelable: true,
					clientX: event.x,
					clientY: event.y,
				}),
			);
			debug('dispatchEvent', { event, effective });
		}
	}
}

function isHTMLIframeElement(element: Element | null): element is HTMLIFrameElement {
	return element?.tagName === 'IFRAME';
}

function isMouseEventPayload(event: any): event is MouseEventPayload {
	return (
		'type' in event &&
		typeof event.type === 'string' &&
		'x' in event &&
		typeof event.x === 'number' &&
		'y' in event &&
		typeof event.y === 'number'
	);
}
