interface IMockWifiDevice {
	connect(password: string): Promise<boolean>;
}

class MockWifiDevice implements IMockWifiDevice {
	public ssid: string;
	public security: string;
	public encrypted: boolean;
	public strength: number;
	private password: string | undefined;

	constructor(ssid: string, encrypted: boolean, strength: number, password?: string, security?: string) {
		this.ssid = ssid;
		this.encrypted = encrypted;
		this.password = password;
		this.security = security ? security : 'None';
		this.strength = strength;
	}

	public connect(password?: string): Promise<boolean> {
		return new Promise<boolean>((resolve: (result: boolean) => void) => {
			resolve(password === this.password);
		});
	}
}

export default MockWifiDevice;
