import * as React from 'react';
import { connect } from 'react-redux';
import { IFrontState } from '../../frontReducers';
import ReconnectingIcon from './ReconnectingIcon';
import { Action } from 'redux';
import CornerStatusIndicator from '../Application/Status/CornerStatusIndicator';

import styles from '../Application/Status/StatusBar.module.sass';

export interface IStateProps {
	debug: boolean;
	isConnected: boolean;
}
export interface IDispatchProps {}

export class SocketIndicator extends React.PureComponent<IStateProps & IDispatchProps, {}> {
	public render() {
		const { isConnected, debug } = this.props;

		if (!isConnected) {
			return (
				<div>
					{debug ? (
						<div className={styles.info}>
							<ReconnectingIcon />
						</div>
					) : null}
					<CornerStatusIndicator top left />
				</div>
			);
		} else {
			return null;
		}
	}
}

export default connect(
	(state: IFrontState) => ({
		isConnected: state.socket && state.socket.connected,
		debug: state.debug.debugOn,
	}),
	(_dispatch: (action: Action) => void) => ({}),
)(SocketIndicator);
