import * as React from 'react';
import { connect } from 'react-redux';
import { IFrontState } from '../../frontReducers';
import { Action } from 'redux';
import { ViolationSeverity } from '../../License/licenseActions';
import { SubscriptionType } from '../../../Display/IConfig';
import styles from './LicenseOverlay.module.sass';

export interface IStateProps {
	violationSeverity: ViolationSeverity;
	subscriptionType: SubscriptionType | null;
	isBuiltUsingApplicationBuilder: boolean;
}
export interface IDispatchProps {}

export class LicenseOverlay extends React.PureComponent<IStateProps & IDispatchProps, {}> {
	public render() {
		const isOpen = this.props.subscriptionType === SubscriptionType.open;
		const isNoSubscription = this.props.subscriptionType === null;
		const isHard = this.props.violationSeverity === ViolationSeverity.hard;
		const isSoft = this.props.violationSeverity === ViolationSeverity.soft;
		if (isOpen && isHard) {
			return <div className={styles.hard}>License expired. Please contact your content provider for license renewal.</div>;
		} else if (isOpen && isSoft) {
			return <div className={styles.soft}>Your license will expire soon. Please contact your content provider for license renewal.</div>;
		} else if (isNoSubscription && this.props.isBuiltUsingApplicationBuilder) {
			return <div className={styles.soft}>Open license requires connection to provider server. See Terms &amp; Conditions.</div>;
		} else {
			return null;
		}
	}
}
export default connect(
	(state: IFrontState) => ({
		violationSeverity: state.license.violationSeverity,
		subscriptionType: state.application.subscriptionType,
		isBuiltUsingApplicationBuilder: !!state.bundledApplet.bundledApplet,
	}),
	(_dispatch: (action: Action) => void) => ({}),
)(LicenseOverlay);
