import * as React from 'react';
import { connect } from 'react-redux';
import classNames from 'classnames';
import { IFrontState } from '../../frontReducers';
import { HandleKeyUp } from '@signageos/actions/dist/Input/keyActions';
import { KeyCode } from '../../../NativeDevice/Input/KeyCode';
import Lock from './lock.svg';
import Backspace from './backspace.svg';
import styles from './NumericKeyboard.module.sass';

export interface IStateProps {
	showKeyboard: boolean;
	enteredCode: string;
	locked: boolean;
}
export interface IDispatchProps {
	handleKeyUp(keyCode: KeyCode): void;
}

export class NumericKeyboard extends React.PureComponent<IStateProps & IDispatchProps> {
	public render() {
		return this.props.showKeyboard ? (
			<div className={styles.keyboard}>
				<div className={styles.row}>
					<div className={styles.cell} onClick={() => this.props.handleKeyUp(KeyCode.NUM_1)}>
						1
					</div>
					<div className={styles.cell} onClick={() => this.props.handleKeyUp(KeyCode.NUM_2)}>
						2
					</div>
					<div className={styles.cell} onClick={() => this.props.handleKeyUp(KeyCode.NUM_3)}>
						3
					</div>
				</div>
				<div className={styles.row}>
					<div className={styles.cell} onClick={() => this.props.handleKeyUp(KeyCode.NUM_4)}>
						4
					</div>
					<div className={styles.cell} onClick={() => this.props.handleKeyUp(KeyCode.NUM_5)}>
						5
					</div>
					<div className={styles.cell} onClick={() => this.props.handleKeyUp(KeyCode.NUM_6)}>
						6
					</div>
				</div>
				<div className={styles.row}>
					<div className={styles.cell} onClick={() => this.props.handleKeyUp(KeyCode.NUM_7)}>
						7
					</div>
					<div className={styles.cell} onClick={() => this.props.handleKeyUp(KeyCode.NUM_8)}>
						8
					</div>
					<div className={styles.cell} onClick={() => this.props.handleKeyUp(KeyCode.NUM_9)}>
						9
					</div>
				</div>
				<div className={styles.row}>
					{this.props.locked ? (
						<div className={styles.cell}></div>
					) : (
						<div className={classNames(styles.cell, styles.lock)} onClick={() => this.props.handleKeyUp(KeyCode.LOCK)}>
							<Lock />
						</div>
					)}
					<div className={styles.cell} onClick={() => this.props.handleKeyUp(KeyCode.NUM_0)}>
						0
					</div>
					{this.props.enteredCode.length === 0 ? (
						<div className={styles.cell}></div>
					) : (
						<div className={classNames(styles.cell, styles.backspace)} onClick={() => this.props.handleKeyUp(KeyCode.BACKSPACE)}>
							<Backspace />
						</div>
					)}
				</div>
				<div className={styles.enteredCode}>{this.props.enteredCode}</div>
			</div>
		) : null;
	}
}

export default connect(
	(state: IFrontState) => ({
		showKeyboard: state.keyboard.showNumericKeyboard,
		enteredCode: state.keyboard.numericCode,
		locked: state.deviceRemoteControl.locked,
	}),
	(dispatch: (action: HandleKeyUp) => void) => ({
		handleKeyUp: (keyCode: KeyCode) =>
			dispatch({
				type: HandleKeyUp,
				keyCode: KeyCode[keyCode],
			} as HandleKeyUp),
	}),
)(NumericKeyboard);
