import * as React from 'react';
import { connect } from 'react-redux';
import { IFrontState } from '../../frontReducers';
import SigningInIcon from './SigningInIcon';
import RegisterFailReason from '@signageos/actions/dist/Device/RegisterFailReason';
import AuthenticationFailReason from '@signageos/actions/dist/Authentication/AuthenticationFailReason';
import { Action } from 'redux';
import CornerStatusIndicator from '../Application/Status/CornerStatusIndicator';

import styles from '../Application/Status/StatusBar.module.sass';

export interface IStateProps {
	debug: boolean;
	authenticated: boolean;
	authenticating: boolean;
	deviceFailReason: RegisterFailReason;
	failReason: AuthenticationFailReason;
}
export interface IDispatchProps {}

export class DisplayAuthenticator extends React.PureComponent<IStateProps & IDispatchProps> {
	public render() {
		const { authenticated, authenticating, debug } = this.props;

		if (!authenticated) {
			return (
				<div>
					{debug ? (
						!authenticating ? (
							<div className={styles.info}>
								<SigningInIcon />
							</div>
						) : (
							<div className={styles.info}>
								{this.props.failReason !== null ? AuthenticationFailReason[this.props.failReason] : null}
								{this.props.deviceFailReason !== null ? RegisterFailReason[this.props.deviceFailReason] : null}
							</div>
						)
					) : null}
					<CornerStatusIndicator bottom left />
				</div>
			);
		} else {
			return null;
		}
	}
}

export default connect(
	(state: IFrontState) => ({
		authenticated: state.authentication.authenticated,
		authenticating: state.authentication.authenticating,
		deviceFailReason: state.device.failReason,
		failReason: state.authentication.failReason,
		debug: state.debug.debugOn,
	}),
	(_dispatch: (action: Action) => void) => ({}),
)(DisplayAuthenticator);
