import * as React from 'react';
import { connect } from 'react-redux';

import { IFrontState } from '../../frontReducers';
import { Action } from 'redux';
import CornerStatusIndicator from '../Application/Status/CornerStatusIndicator';

import LoadingIcon from './LoadingIcon';

import styles from '../Application/Status/StatusBar.module.sass';

export interface ActiveAppletStatusProps {
	debug: boolean;
	appletMissing: boolean;
	appletChecksum: string;
	appletIsMuted: boolean;
}

class ActiveAppletStatus extends React.PureComponent<ActiveAppletStatusProps, any> {
	public render() {
		const { appletMissing, appletChecksum, appletIsMuted, debug } = this.props;

		if (!appletMissing && !appletChecksum && !appletIsMuted) {
			return (
				<div>
					{debug ? (
						<div className={styles.info}>
							<LoadingIcon />
						</div>
					) : null}
					<CornerStatusIndicator bottom right />
				</div>
			);
		} else {
			return null;
		}
	}
}

export default connect(
	(state: IFrontState) => ({
		appletMissing: state.applet.activeAppletMissing,
		appletChecksum: state.applet.activeTimingChecksum,
		appletIsMuted: state.applet.appletIsMuted,
		debug: state.debug.debugOn,
	}),
	(_dispatch: (action: Action) => void) => ({}),
)(ActiveAppletStatus);
