import { SaveHTML5TestResult, TestCase } from '@signageos/actions/dist/Device/Test/deviceTestActions';
import * as t from './../../Test/TestFramework';
import { Dispatch } from 'redux';
import { IFrontState } from '../frontReducers';

const DEFAULT_TIMEOUT = 300e3;

export default async (dispatch: Dispatch<IFrontState>) => {
	return t.describe(TestCase.HTML5, function* () {
		yield t.it(
			'Run HTML test',
			async () => {
				// tslint:disable-next-line
				const testResult = await runHtml5Test();
				dispatch({
					type: SaveHTML5TestResult,
					testResult,
				} as SaveHTML5TestResult);
			},
			DEFAULT_TIMEOUT,
		);
	});
};

// Bundled html5test script, replaced at build time
declare const __HTML5TEST_SCRIPT__: string;

// Create a script tag with prebuilt script and append it to body
export const runHtml5Test = () =>
	new Promise((resolve) => {
		const script = document.createElement('script');
		// Global variable which the script calls back
		(window as any).__SOS_HTML5TEST_RESOLVE = resolve;
		script.innerHTML = __HTML5TEST_SCRIPT__;
		document.body.appendChild(script);
	});
