import ICacheDriver from '../../NativeDevice/ICacheDriver';
import should from '../../Test/should';
import * as t from './../../Test/TestFramework';
import { TestCase } from '@signageos/actions/dist/Device/Test/deviceTestActions';

export default async (nativeDriver: ICacheDriver) => {
	return t.describe(TestCase.CACHE, function* () {
		yield t.it('should test cacheGet, cacheGetAll, cacheDelete', async () => {
			const TEST_UID = 'Front.Cache.Test.Key';
			const TEST_CONTENT = 'Front.Cache.Test.Value';

			await nativeDriver.cacheSave(TEST_UID, TEST_CONTENT);
			const loadedValue = await nativeDriver.cacheGet(TEST_UID);
			should(loadedValue).equal(TEST_CONTENT);

			const allLoadedContentsWith = await nativeDriver.cacheGetAll();

			should(Object.keys(allLoadedContentsWith)).containEql(TEST_UID);
			should(allLoadedContentsWith[TEST_UID]).equal(TEST_CONTENT);

			await nativeDriver.cacheDelete(TEST_UID);

			const allLoadedContentsWithout = await nativeDriver.cacheGetAll();

			should(Object.keys(allLoadedContentsWithout)).not.containEql(TEST_UID);

			try {
				await nativeDriver.cacheGet(TEST_UID);
				should(true).be.false();
			} catch (e) {
				should(true).be.true();
			}
		});

		yield t.it('should test cacheGetStorageInfo', async () => {
			const { totalSizeBytes, availableBytes, usedBytes } = await nativeDriver.cacheGetStorageInfo();
			should(typeof totalSizeBytes).equal('number');
			should(typeof availableBytes).equal('number');
			should(typeof usedBytes).equal('number');
			should(totalSizeBytes).greaterThanOrEqual(availableBytes);
			should(availableBytes).greaterThanOrEqual(0);
			should(availableBytes + usedBytes).be.approximately(totalSizeBytes, totalSizeBytes / 50);
		});
	});
};
