import { put, takeEvery } from 'redux-saga/effects';
import { StartApplication } from '@signageos/actions/dist/Application/applicationActions';
import { UpdateActiveAppletBinary } from '@signageos/actions/dist/Applet/appletActions';
import { IFrontManagementDriver } from '../../NativeDevice/Management/IManagementDriver';
import { NetworkStatusChanged } from '../Network/networkActions';
import { createSystemLogAction } from '../../SystemLogs/systemLogActionFactory';
import { AppletPing } from '@signageos/actions/dist/Applet/activeAppletActions';
import {
	AppletRunning,
	AppletStarted,
	ApplicationStarted,
	NetworkChanged,
} from '@signageos/common-types/dist/Device/SystemLogs/systemLogs';

export function* systemLogsSaga(getManagementDriver: () => IFrontManagementDriver) {
	yield takeEvery(StartApplication, function* (): IterableIterator<any> {
		yield put(
			createSystemLogAction({
				type: ApplicationStarted,
				startedAt: new Date(),
			} satisfies ApplicationStarted),
		);
	});
	yield takeEvery(UpdateActiveAppletBinary, function* (action: UpdateActiveAppletBinary): IterableIterator<any> {
		yield put(
			createSystemLogAction({
				type: AppletStarted,
				appletUid: action.activeAppletUid,
				appletVersion: action.activeAppletVersion,
			} satisfies AppletStarted),
		);
	});
	yield takeEvery(NetworkStatusChanged, function* (): IterableIterator<any> {
		const networkStatus = yield getManagementDriver().network.listInterfaces();
		if (networkStatus) {
			yield put(
				createSystemLogAction({
					type: NetworkChanged,
					data: networkStatus,
				} satisfies NetworkChanged),
			);
		}
	});

	yield takeEvery(AppletPing, function* (action: AppletPing): IterableIterator<any> {
		yield put(
			createSystemLogAction({
				type: AppletRunning,
				appletUid: action.appletUid,
			} satisfies AppletRunning),
		);
	});
}
