import IFrontDriver from '../../NativeDevice/Front/IFrontDriver';
import ICacheDriver from '../../NativeDevice/ICacheDriver';
import createPropertyStorage from '../../Property/propertyStorage';
import DefaultSecurity from './DefaultSecurity';
import IPinStorage from './IPinStorage';
import ISecurity from './ISecurity';
import PinPropertyStorage from './PinPropertyStorage';

export const DEFAULT_OPEN_PIN_CODE = '0000';

export function createSecurity(storage: IPinStorage, onSetPin: (pin: string) => Promise<void>): ISecurity {
	return new DefaultSecurity(storage, onSetPin);
}

export function createCompatibleSecurity(getFrontDriver: () => IFrontDriver, getCacheDriver: () => ICacheDriver): ISecurity;
export function createCompatibleSecurity(getNativeDriver: () => IFrontDriver & ICacheDriver): ISecurity;
export function createCompatibleSecurity(
	...args: [getFrontDriver: () => IFrontDriver, getCacheDriver: () => ICacheDriver] | [getNativeDriver: () => IFrontDriver & ICacheDriver]
): ISecurity {
	const getFrontDriver = args[0];
	const getCacheDriver = args.length === 1 ? args[0] : args[1];

	const properties = createPropertyStorage(getCacheDriver);
	const storage = new PinPropertyStorage(properties);
	return createSecurity(storage, (pin: string) => getFrontDriver().controlSetPin(pin));
}
