import { StartApplication } from '@signageos/actions/dist/Application/applicationActions';
import { Connected, Disconnected } from '@signageos/actions/dist/Network/networkActions';
import { NetworkInterface } from '@signageos/common-types/dist/Device/Network/NetworkInterface';
import wait from '@signageos/lib/dist/Timer/wait';
import _ from 'lodash';
import { call, put, takeEvery } from 'redux-saga/effects';
import IDriver from '../../NativeDevice/Front/IFrontDriver';
import { IFrontManagementDriver } from '../../NativeDevice/Management/IManagementDriver';
import { IFrontState } from '../frontReducers';
import { NetworkStatusChanged } from './networkActions';

export function* networkConnection(
	getState: () => IFrontState,
	getNativeDriver: () => IDriver,
	getManagementDriver: () => IFrontManagementDriver,
) {
	yield takeEvery(StartApplication, checkingConnection, getState, getNativeDriver);
	yield takeEvery(StartApplication, checkingStatusChange, getManagementDriver);
}

function* checkingConnection(getState: () => IFrontState, getNativeDriver: () => IDriver) {
	try {
		while (true) {
			const isNowConnected: boolean = yield getNativeDriver().isConnected();
			if (getState().network.connected !== isNowConnected) {
				yield put({
					type: isNowConnected ? Connected : Disconnected,
				});
			}
			yield call(wait, 60 * 1e3);
		}
	} catch (error) {
		console.error('checkingConnection failed', error);
	}
}

export function* checkingStatusChange(getManagementDriver: () => IFrontManagementDriver) {
	let lastStatus: NetworkInterface[] = [];

	try {
		while (true) {
			const status: NetworkInterface[] = yield getManagementDriver().network.listInterfaces();
			if (!_.isEqual(lastStatus, status)) {
				yield put<NetworkStatusChanged>({ type: NetworkStatusChanged, data: status });
				lastStatus = status;
			}
			yield call(wait, 60e3);
		}
	} catch (error) {
		console.error('checkingStatusChange failed', error);
	}
}
