import { KeyCode } from '../../NativeDevice/Input/KeyCode';

const CharacterKeyMap: { [tvKeyCode: number]: KeyCode } = {
	[KeyCode.NUM_0]: 0,
	[KeyCode.NUM_1]: 1,
	[KeyCode.NUM_2]: 2,
	[KeyCode.NUM_3]: 3,
	[KeyCode.NUM_4]: 4,
	[KeyCode.NUM_5]: 5,
	[KeyCode.NUM_6]: 6,
	[KeyCode.NUM_7]: 7,
	[KeyCode.NUM_8]: 8,
	[KeyCode.NUM_9]: 9,
};

export function getNumericCode(sequence: string[]) {
	return sequence.reduce((numericCode: string, keyCode: keyof typeof KeyCode) => {
		if (Object.keys(CharacterKeyMap).indexOf(KeyCode[keyCode].toString()) !== -1) {
			return numericCode + CharacterKeyMap[KeyCode[keyCode]];
		}

		if (keyCode === KeyCode[KeyCode.BACKSPACE]) {
			return numericCode.slice(0, numericCode.length - 1);
		}

		return numericCode;
	}, '');
}
