import { put, fork, takeEvery } from 'redux-saga/effects';
import { createChannel, takeEvery as takeEveryChannelMessage } from '../../ReduxSaga/channels';
import { StartApplication } from '@signageos/actions/dist/Application/applicationActions';
import { HandleKeyUp, HandleKeySequence } from '@signageos/actions/dist/Input/keyActions';
import IDriver from '../../NativeDevice/Front/IFrontDriver';
import IKeyUpEvent from '../../NativeDevice/Input/IKeyUpEvent';
import { KeyCode } from '../../NativeDevice/Input/KeyCode';

export function* keyUpSaga(getNativeDriver: () => IDriver) {
	yield takeEvery(StartApplication, function* () {
		try {
			const nativeDriver = getNativeDriver();
			const keyUpChannel = createChannel((putHere: (keyUpEvent: IKeyUpEvent) => void) =>
				nativeDriver.bindKeyUp((keyUpEvent: IKeyUpEvent) => putHere(keyUpEvent)),
			);
			yield takeEveryChannelMessage(keyUpChannel, function* (keyUpEvent: IKeyUpEvent) {
				yield put<HandleKeyUp>({
					type: HandleKeyUp,
					keyCode: KeyCode[keyUpEvent.keyCode],
				});
			});
		} catch (error) {
			console.error('keyUpSaga', error);
		}
	});
}

export function* keySequenceSaga(window: Window) {
	let cleanSequenceTimeout: number;
	let pressedSequence: (keyof KeyCode)[] = [];
	yield takeEvery(HandleKeyUp, function* (handleKeyUp: HandleKeyUp) {
		try {
			window.clearTimeout(cleanSequenceTimeout);
			yield fork(function* () {
				yield new Promise<void>((resolve: () => void) => {
					cleanSequenceTimeout = window.setTimeout(() => resolve(), 4 * 1e3);
				});
				pressedSequence = [];
				yield put<HandleKeySequence>({
					type: HandleKeySequence,
					sequence: [...pressedSequence],
				});
			});
			if (handleKeyUp.keyCode !== undefined) {
				pressedSequence.push(handleKeyUp.keyCode as keyof KeyCode);
				yield put<HandleKeySequence>({
					type: HandleKeySequence,
					sequence: [...pressedSequence],
				});
			}
		} catch (error) {
			console.error('keySequenceSaga', error);
		}
	});
}
