import { DeviceRemoteControlSet } from '../../../Device/RemoteControl/deviceRemoteControlActions';

export interface IDeviceRemoteControlState {
	locked: boolean;
}

const initialState: IDeviceRemoteControlState = {
	locked: true,
};

export function deviceRemoteControl(state: IDeviceRemoteControlState = initialState, action: DeviceRemoteControlSet) {
	switch (action.type) {
		case DeviceRemoteControlSet:
			return {
				locked: !action.enabled,
			};
		default:
			return state;
	}
}
