import { bindWhenPlatform } from '../../../Socket/socketActionCreator';
import { CancelScheduledPowerAction, SchedulePowerAction } from '@signageos/actions/dist/Device/Power/devicePowerActions';
import PowerActionType from '@signageos/actions/dist/Device/Power/PowerActionType';
import { deviceSchedulePowerActionCommon } from '../../../Device/Power/deviceSchedulePowerActionSagas';
import { IPropertyStorage } from '../../../Property/propertyStorage';
import { createFrontPowerActionTimer } from './powerActionTimers';
import FrontPowerActionExecutor from './FrontPowerActionExecutor';

export function* deviceSchedulePowerAction(propertyStorage: IPropertyStorage) {
	yield bindWhenPlatform([SchedulePowerAction, CancelScheduledPowerAction]);

	const powerActionExecutor = new FrontPowerActionExecutor();
	const powerActionTimer = createFrontPowerActionTimer(propertyStorage, powerActionExecutor);

	yield powerActionExecutor.takeEveryAction();

	yield deviceSchedulePowerActionCommon(powerActionTimer, (powerType: PowerActionType) => {
		return (
			powerType === PowerActionType.APPLET_REFRESH ||
			powerType === PowerActionType.APPLET_RELOAD ||
			powerType === PowerActionType.APPLET_ENABLE ||
			powerType === PowerActionType.APPLET_DISABLE
		);
	});
}
