import { ForkEffect, put, takeEvery } from 'redux-saga/effects';
import PowerActionType from '@signageos/actions/dist/Device/Power/PowerActionType';
import { PerformScheduledPowerAction } from './devicePowerActionActions';
import IPowerActionExecutor from '../../../NativeDevice/Power/IPowerActionExecutor';
import { buffers, channel, Channel } from 'redux-saga';

export default class FrontPowerActionExecutor implements IPowerActionExecutor {
	private readonly channel: Channel<PowerActionType> = channel<PowerActionType>(buffers.none());

	public execute(powerAction: PowerActionType): void {
		this.channel.put(powerAction);
	}

	public takeEveryAction(): ForkEffect<never> {
		return takeEvery(this.channel, function* (powerType: PowerActionType) {
			yield put({
				type: PerformScheduledPowerAction,
				powerType,
			} as PerformScheduledPowerAction);
		});
	}
}
